#pragma once
#include "BaseShader.h"
#include "Light.h"

using namespace std;
using namespace DirectX;

//Base class used to encapsulate common variables, buffers and functions between shaders
class BowerShader : public BaseShader
{
	public:
		BowerShader(ID3D11Device* device, HWND hwnd);
		~BowerShader();

		//Used so each shader can access light info - reduces arguments in setShaderParameters
		void SetSunLight(Light *sunLight) { _SunLight = sunLight; };
		void SetSpotLight(Light* spotLight) { _SpotLight = spotLight; }
		void SetHillLight(Light* hillLight) { _HillLight = hillLight; };

	protected:
		//Lights
		Light* _SunLight;
		Light* _SpotLight;
		Light* _HillLight;

		//The buffer for all the light info
		struct LightBufferType
		{
			XMFLOAT4 sunAmbient;
			XMFLOAT4 sunDiffuse;
			XMFLOAT3 sunDirection;
			float padding;
			XMFLOAT4 spotDiffuse;
			XMFLOAT3 spotPosition;
			float constantFactor;
			float linearFactor;
			float quadraticFactor;
			XMFLOAT2 paddingTwo;
			XMFLOAT3 spotDirection;
			float paddingThree;
			XMFLOAT4 hillDiffuse;
			XMFLOAT3 hillPosition;
			float paddingFour;
		};

		//Buffer for storing all the shadow info, like positions, view and projection matrices
		struct ShadowMatrixBufferType
		{
			XMMATRIX world;
			XMMATRIX view;
			XMMATRIX projection;
			XMMATRIX sunLightView;
			XMMATRIX sunLightProjection;
			XMMATRIX spotLightView;
			XMMATRIX spotLightProjection;
			XMMATRIX hillLightViews[6];
			XMMATRIX hillLightProjections[6];
		};

		//Buffer for storing tessellation factors
		struct DynamicTessType
		{
			float minTessFactor;
			XMFLOAT3 cameraPos;
			float maxTessFactor;
			XMFLOAT3 padding;
		};

		XMMATRIX GetYAxisViewMatrix(Light* light);
};

